<?php include '../header.php'; ?>
<?php include '../sidebar.php'; ?>
<?php include '../content.php'; ?>

<h1>Combination of Range, Area and Line Charts</h1>
<div id="chartContainer"></div>

<?php
    $dataPoints = array(
        array("label"=> "Jan", "y"=> array(4, 8)),
        array("label"=> "Feb", "y"=> array(3, 8)),
        array("label"=> "Mar", "y"=> array(5, 11)),
        array("label"=> "Apr", "y"=> array(8, 18)),
        array("label"=> "May", "y"=> array(12, 20)),
        array("label"=> "Jun", "y"=> array(17, 26)),
        array("label"=> "Jul", "y"=> array(19, 28)),
        array("label"=> "Aug", "y"=> array(19, 28)),
        array("label"=> "Sep", "y"=> array(16, 25)),
        array("label"=> "Oct", "y"=> array(12, 19)),
        array("label"=> "Nov", "y"=> array(9, 14)),
        array("label"=> "Dec", "y"=> array(6, 10))
    );
?>

<script>
    window.onload = function () {
        var chart = new CanvasJS.Chart("chartContainer", {
            //theme: "light2",
            title: {
                text: "Temperature Variation of Istanbul Over a Year"
            },
            axisY: {
                title: "Temperature (in °C)"
            },
            toolTip: {
                shared: true
            },
            legend: {
                dockInsidePlotArea: true,
                cursor: "pointer",
                itemclick: toggleDataSeries
            },
            data: [{
                type: "rangeArea",
                markerSize: 0,
                name: "Temperature Range",
                showInLegend: true,
                toolTipContent: "{label}<br><span style=\"color:#6D77AC\">{name}</span><br>Min: {y[0]} °C<br>Max: {y[1]} °C",
                dataPoints: <?php echo json_encode($dataPoints, JSON_NUMERIC_CHECK); ?>
            }]
        });
        chart.render();
        
        addAverages();
        
        function addAverages() {
            var dps = [];
            for(var i = 0; i < chart.options.data[0].dataPoints.length; i++) {
                dps.push({
                    label: chart.options.data[0].dataPoints[i].label,
                    y: (chart.options.data[0].dataPoints[i].y[0] + chart.options.data[0].dataPoints[i].y[1]) / 2
                });
            }
            chart.options.data.push({
                type: "line",
                name: "Average",
                showInLegend: true,
                markerType: "triangle",
                markerSize: 0,
                yValueFormatString: "##.0 °C",
                dataPoints: dps
            });
            chart.render();
        }
        
        function toggleDataSeries(e) {
            if (typeof (e.dataSeries.visible) === "undefined" || e.dataSeries.visible) {
                e.dataSeries.visible = false;
            } else {
                e.dataSeries.visible = true;
            }
            e.chart.render();
        }
    }
</script>

<?php include '../footer.php'; ?>